<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AppClient extends Model 
{

    protected $table = 'app_clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'address', 'phone', 'phone2', 'website', 'status', 'user_id');

    public function companies()
    {
        return $this->hasMany('App\Models\MainCompany');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}